<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 11.12.13 15:14
 */

namespace VM\AdminBundle\Services;

use Doctrine\ORM\EntityManager;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;

class NotesCommunication
{
    /**
     * Url to SSO
     * @var string
     */
    protected $notesUrl;


    /**
     * Curl request object
     *
     * @var
     */
    protected $curlRequest;



    public function __construct($notesUrl)
    {
        $this->notesUrl = $notesUrl;
    }


    public function getNumberOfNotes($users)
    {
        $this->initConnection();
        $data = array(
            'user_ids' => $users
        );
        return $this->executeAndGetResponse('getUserNotesQuantity', $data);
    }



    protected function initConnection()
    {
        $this->curlRequest = curl_init($this->notesUrl);
    }



    protected function executeAndGetResponse($method, $data)
    {
        $data['method'] = $method;

        $options = array(
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => array('Content-type: application/json') ,
            CURLOPT_POSTFIELDS => json_encode($data)
        );

        curl_setopt_array($this->curlRequest, $options);

        $response = curl_exec($this->curlRequest);

        $this->primaryValidation($response);

        return json_decode($response, true);
    }


    /**
     * @param $responseString
     * @throws \Exception
     */
    protected function primaryValidation($responseString)
    {
        $info = curl_getinfo($this->curlRequest);
        if($info['http_code'] != 200)
        {
            throw new \Exception('response is empty', 404);
        }

        $error = curl_error($this->curlRequest);
        if(!empty($error))
        {
            throw new \Exception($error, 1010);
        }

        if(empty($responseString))
        {
            throw new \Exception('response is empty', 1000);
        }

        $response = json_decode($responseString, true);
        if(isset($response['error']))
        {
            throw new \Exception('Error Authorization SSO (code: '.$response['code'].')', $response['code']);
        }
    }
}